#!/usr/bin/env python

# Save Report Layouts
# Copyright 2004, 2006 by Brian C. Christensen

"""
Save the reports and report columns of the currently selected project
  (main window), as a script (.py) file.  If executed, the file adds those
  reports to the currently selected project.
"""

#    This file is part of GanttPV.
#
#    GanttPV is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    GanttPV is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with GanttPV; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# 041224 - added report & column extract logic
# 041225 - changed indent
# 060414 - Alex - rewritten to generate a runnable script

import os

SkipReportFields = ['ID', 'ProjectID', 'FirstColumn', 'FirstRow', 'zzStatus',

    # screen position
    'Open', 'FramePositionX', 'FramePositionY', 'FrameSizeW', 'FrameSizeH',

    # print settings
    'PrintScale', 'PageOrientation', 'PaperID', 'PaperHeight', 'PaperWidth', 'MarginLeft', 'MarginTop', 'MarginRight', 'MarginBottom',

    ]

SkipColumnFields = ['ID', 'ReportID', 'NextColumn', 'zzStatus',
    'A', 'B', 'TypeA', 'TypeB', 'Time',  # deprecated by ColumnType
    'FirstDate',  # default time-scales to today
    ]

signature = '# generated by "' + os.path.basename(thisfile) + '" on ' + Data.GetToday()

header = """#!/usr/bin/env python

""" + signature + """

try:
    AddColumn = Data.AddColumn
    AddReport = Data.AddReport
except AttributeError:
    # running older version of GanttPV; use the defaults below

    def AddColumn(reportid, column):
        change = column.copy()
        change['Table'] = 'ReportColumn'
        change['ReportID'] = reportid

        # convert report and column type names to id
        rtname, ctname = column.get('ColumnTypeID')
        rtid = Data.FindID('ReportType', 'Name', rtname, None, None)
        if not rtid: return
        ctid = Data.FindID('ColumnType', 'Name', ctname, 'ReportTypeID', rtid)
        if not ctid: return
        change['ColumnTypeID'] = ctid

        id = Data.Update(change)['ID']
        return id

    def AddReport(projectid, report, columns=None):
        change = report.copy()
        change['Table'] = 'Report'
        change['ProjectID'] = projectid

        # convert report type name to id
        rtname = report.get('ReportTypeID')
        rtid = Data.FindID('ReportType', 'Name', rtname, None, None)
        if not rtid: return
        change['ReportTypeID'] = rtid

        if 'Name' not in change:
            rt = Data.ReportType[rtid]
            change['Name'] = rt.get('Label') or rt.get('Name')

        if projectid != 1:
            change['SelectColumn'] = 'ProjectID'
            change['SelectValue'] = projectid

        reportid = Data.Update(change)['ID']
        if reportid and columns:
            clist = [AddColumn(reportid, c) for c in columns]
            Data.ReorderReportColumns(reportid, clist)
        return reportid

def Do():
    # get the definition of the currently selected report row
    item = self.Report.currentItem  # selected list item
    if item == None:
        if debug: print "no item selected"
        return
    rowid = self.Report.rows[item]  # report row id
    rr = Data.ReportRow[rowid]  # report row record

    # make sure that a project row is selected
    rowtable = rr.get('TableName')
    if rowtable != 'Project':
        if debug: print "rowtable not project", rowtable
        return
    projectid = rr.get('TableID')
    project = Data.Project.get(projectid)
    if not project or project.get('zzStatus') == 'deleted':
        if debug: print "project id not valid", rowid
        return

# -------- begin report definitions --------
"""

footer = """# -------- end of report definitions --------

    Data.SetUndo('Add Reports')

Do()
"""


def SaveReport(output, reportid):
    if debug: print "reportid", reportid
    report = Data.Report.get(reportid)
    if not report: return

    rtid = report.get('ReportTypeID')
    rt = Data.ReportType.get(rtid)
    if not rt: return
    if debug: print 'report type:', rt

    projectType = rt.get('AllOrEach')
    if (not projectType) and rt.get('TableA') != 'Task':
        print >> output, "    if projectid == 1:"
    elif projectType == 'all':
        print >> output, "    if projectid == 1:"
    elif projectType == 'each':
        print >> output, "    if projectid != 1:"
    else:
        print >> output, "    if True:"

    print >> output, "        report = {",
    for k, v in report.iteritems():
        if k in SkipReportFields:
            continue
        elif k == 'ReportTypeID':
            rtname = rt.get('Name')
            print >> output, repr(k) + ':', repr(rtname) + ",",
        elif v or v == 0:
            print >> output, repr(k) + ':', repr(v) + ",",
    print >> output, "}"

    print >> output, "        columns = ["
    for c in Data.GetColumnList(reportid):
        rc = Data.ReportColumn.get(c)
        if not rc: continue

        ctid = rc.get('ColumnTypeID')
        ct = Data.ColumnType.get(ctid)
        if not ct: continue

        rtid = ct.get('ReportTypeID')
        rt = Data.ReportType.get(rtid)
        if not rt: continue

        rtname = rt.get('Name')
        ctname = ct.get('Name')

        print >> output, "            {",
        for k, v in rc.iteritems():
            if k in SkipColumnFields:
                continue
            elif k == 'ColumnTypeID':
                print >> output, repr(k) + ':', repr((rtname, ctname)) + ",",
            elif v or v == 0:
                print >> output, repr(k) + ':', repr(v) + ",",
        print >> output, "},"
    print >> output, "            ]"
    print >> output, "        AddReport(projectid, report, columns)\n"

def SaveReports(output, projectid):
    if debug: print "projectid", projectid

    print >> output, header
    reports = Data.FindIDs('Report', 'ProjectID', projectid, None, None)
    for reportid in reports:
        SaveReport(output, reportid)
    print >> output, footer

def Do():
    item = self.Report.currentItem
    if item == None:
        if debug: print "no item selected"
        return

    # get the definition of the currently selected report row
    item = self.Report.currentItem  # selected list item
    if item == None:
        return
    rowid = self.Report.rows[item]  # report row id
    rr = Data.ReportRow[rowid]  # report row record

    # make sure that a project row is selected
    rowtable = rr['TableName']
    rowtable = rr.get('TableName')
    if rowtable != 'Project':
        if debug: print "rowtable not project", rowtable
        return
    projectid = rr.get('TableID')
    project = Data.Project.get(projectid)
    if not project or project.get('zzStatus') == 'deleted':
        if debug: print "project id not valid", projectid
        return

    name = project.get('Name') or 'Saved Reports'
    wildcardx = "Python Script (*.py)|*.py" "|" "All files (*.*)|*.*"
    path = wx.FileSelector('Save file as ...', '', name + '.py', '', wildcardx, wx.SAVE | wx.OVERWRITE_PROMPT)
    if path:
        fp = file(path, 'w')  # create file
        SaveReports(fp, projectid)

Do()
